package com.ejie.ab04b.dao.temp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DocumentosOS3TempDaoImpl generated by UDA, 29-jun-2017 10:57:17.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class DocumentosOS3TempDaoImpl implements DocumentosOS3TempDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT_COLUMNAS = "SELECT t1.ID_TIPO_DOC_091 IDTIPODOC091,t1.DESCRIPCION_ES_091 DESCRIPCIONES091,"
			+ " t1.DESCRIPCION_EU_091 DESCRIPCIONEU091, t1.TIPO_DOKUSI_091 TIPODOKUSI091, t1.ASUNTO_DOKUSI_091 ASUNTODOKUSI091, "
			+ " t1.APORT_GEN_091 APORTGEN091, t2.ID_DOCUMENTO_029 IDDOCUMENTO029, t2.TEROS3_029 TEROS3029, "
			+ " t2.ANOOS3_029 ANOOS3029,  t2.NUMOS3_029 NUMOS3029, "
			+ " t2.ID_TIPO_DOC_029 IDTIPODOC029, t2.RUTA_PIF_029 RUTAPIF029, t2.NOMBRE_DOC_029 NOMBREDOC029, "
			+ " t2.OID_DOKUSI_029 OIDDOKUSI029 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoOS3> rwMap = new RowMapper<DocumentoOS3>() {
		public DocumentoOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			DocumentoOS3 documento = new DocumentoOS3(
					resultSet.getLong("IDDOCUMENTO029"), null, null,
					resultSet.getString("RUTAPIF029"),
					resultSet.getString("NOMBREDOC029"),
					resultSet.getString("OIDDOKUSI029"), new TipoDocumento(
							resultSet.getLong("IDTIPODOC029")), null, null,
					null, new TramiteOS3(null, null, new OS3(
							resultSet.getString("TEROS3029"),
							resultSet.getString("ANOOS3029"),
							resultSet.getInt("NUMOS3029"))));
			return documento;
		}
	};

	private RowMapper<DocumentoOS3> rwMapTipo = new RowMapper<DocumentoOS3>() {
		public DocumentoOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoOS3 documento = new DocumentoOS3(
					resultSet.getLong("IDDOCUMENTO029"), null, null,
					resultSet.getString("RUTAPIF029"),
					resultSet.getString("NOMBREDOC029"),
					resultSet.getString("OIDDOKUSI029"), new TipoDocumento(
							resultSet.getLong("IDTIPODOC029")), null, null,
					null, new TramiteOS3(null, null, new OS3(
							resultSet.getString("TEROS3029"),
							resultSet.getString("ANOOS3029"),
							resultSet.getInt("NUMOS3029"))));

			documento.setTipoDocumento(new TipoDocumento((resultSet
					.getLong("IDTIPODOC029") == 0 ? resultSet
					.getLong("IDTIPODOC091") : resultSet
					.getLong("IDTIPODOC029")), resultSet
					.getString("DESCRIPCIONES091"), resultSet
					.getString("DESCRIPCIONEU091"), resultSet
					.getString("TIPODOKUSI091"), resultSet
					.getString("ASUNTODOKUSI091"), resultSet
					.getString("APORTGEN091")));

			return documento;
		}
	};

	private RowMapper<DocumentoOS3> rwMapPK = new RowMapper<DocumentoOS3>() {
		public DocumentoOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocumentoOS3(resultSet.getLong("IDDOCUMENTO029"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0429stemp table.
	 * 
	 * ab0429stemp Ab0429stemp Ab0429stemp
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @return the documento os3
	 */
	public DocumentoOS3 add(DocumentoOS3 ab0429stemp) {
		String query = "INSERT INTO AB0429S00 (ID_DOCUMENTO_029, TEROS3_029, ANOOS3_029, NUMOS3_029, RUTA_PIF_029, NOMBRE_DOC_029, ID_TIPO_DOC_029) VALUES (?,?,?,?,?,?,?)";

		Long idDocumentoTemp = UtilDAO.getNextId(this.jdbcTemplate,
				Secuencias.DOC_OS3_TEMP.getCodSecuencia());

		ab0429stemp.setIdDocumento097(idDocumentoTemp);

		this.jdbcTemplate.update(query, ab0429stemp.getIdDocumento097(),
				ab0429stemp.getTramiteOS3().getOs3().getTeros3061(),
				ab0429stemp.getTramiteOS3().getOs3().getAnoos3061(),
				ab0429stemp.getTramiteOS3().getOs3().getNumos3061(),
				ab0429stemp.getRutaPif097(), ab0429stemp.getNombreDoc097(),
				ab0429stemp.getTipoDocumento().getIdTipoDoc091());
		return ab0429stemp;
	}

	/**
	 * Updates a single row in the Ab0429stemp table.
	 * 
	 * ab0429stemp Ab0429stemp Ab0429stemp
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @return the documento os3
	 */
	public DocumentoOS3 update(DocumentoOS3 ab0429stemp) {
		String query = "UPDATE AB0429S00 SET TEROS3_029=?, ANOOS3_029=?, NUMOS3_029=?, RUTA_PIF_029=?, NOMBRE_DOC_029=?, ID_TIPO_DOC_029=?, OID_DOKUSI_029=? WHERE ID_DOCUMENTO_029=?";
		this.jdbcTemplate.update(query, ab0429stemp.getTramiteOS3().getOs3()
				.getTeros3061(), ab0429stemp.getTramiteOS3().getOs3()
				.getAnoos3061(), ab0429stemp.getTramiteOS3().getOs3()
				.getNumos3061(), ab0429stemp.getRutaPif097(), ab0429stemp
				.getNombreDoc097(), ab0429stemp.getTipoDocumento()
				.getIdTipoDoc091(), ab0429stemp.getOidDokusi097(), ab0429stemp
				.getIdDocumento097());
		return ab0429stemp;
	}

	/**
	 * Finds a single row in the Ab0429stemp table.
	 * 
	 * ab0429stemp Ab0429stemp Ab0429stemp
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @return the documento os3
	 */
	@Transactional(readOnly = true)
	public DocumentoOS3 find(DocumentoOS3 ab0429stemp) {
		String query = "SELECT t1.ID_DOCUMENTO_029 IDDOCUMENTO029,t1.TEROS3_029 TEROS3029,t1.ANOOS3_029 ANOOS3029,t1.NUMOS3_029 NUMOS3029, t1.RUTA_PIF_029 RUTAPIF029, t1.NOMBRE_DOC_029 NOMBREDOC029, t1.ID_TIPO_DOC_029 IDTIPODOC029, t1.OID_DOKUSI_029 OIDDOKUSI029 FROM AB0429S00 t1  WHERE t1.ID_DOCUMENTO_029 = ?  ";

		List<DocumentoOS3> ab0429stempList = this.jdbcTemplate.query(query,
				this.rwMap, ab0429stemp.getIdDocumento097());
		return (DocumentoOS3) DataAccessUtils.uniqueResult(ab0429stempList);
	}

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 * documento DocumentoOS3
	 * 
	 * List<DocumentoOS3>.
	 * 
	 * @param documento
	 *            the documento os3
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS3> buscarDocumentosOS3TempTipo(DocumentoOS3 documento) {
		StringBuilder query = new StringBuilder(
				DocumentosOS3TempDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(" FROM AB0491S00 t1 LEFT JOIN AB0429S00 t2 ON  t2.ID_TIPO_DOC_029  = t1.ID_TIPO_DOC_091 ");
		query.append(" AND t2.TEROS3_029 = ? AND t2.ANOOS3_029 = ? AND t2.NUMOS3_029 = ?  WHERE t1.APORT_GEN_091    = ? ");
		query.append(" AND t1.ASUNTO_DOKUSI_091 != '"
				+ Constantes.TIPO_DOC_INFORME_INSPECCION
				+ "' AND t1.ID_TIPO_DOC_091='6' ");
		query.append(" order by t1.ORDER_091 ");

		return (List<DocumentoOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTipo, documento.getTramiteOS3().getOs3()
						.getTeros3061(), documento.getTramiteOS3().getOs3()
						.getAnoos3061(), documento.getTramiteOS3().getOs3()
						.getNumos3061(), documento.getTipoDocumento()
						.getAportGen091());
	}

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 * documento DocumentoOS3
	 * 
	 * List<DocumentoOS3>.
	 * 
	 * @param documento
	 *            the documento os3
	 * @return the list
	 */

	@Transactional(readOnly = true)
	public List<DocumentoOS3> buscarDocumentosOS3Temp(DocumentoOS3 documento) {
		StringBuilder query = new StringBuilder(
				DocumentosOS3TempDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(" FROM AB0491S00 t1 LEFT JOIN AB0429S00 t2 ON  t2.ID_TIPO_DOC_029 = t1.ID_TIPO_DOC_091 ");
		query.append(" WHERE t2.TEROS3_029 = ?  ");
		query.append(" AND t2.ANOOS3_029 = ?  ");
		query.append(" AND t2.NUMOS3_029 = ?  ");
		query.append(" order by idtipodoc091 ");

		return (List<DocumentoOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTipo, documento.getTramiteOS3().getOs3()
						.getTeros3061(), documento.getTramiteOS3().getOs3()
						.getAnoos3061(), documento.getTramiteOS3().getOs3()
						.getNumos3061());
	}

	/**
	 * Removes a single row in the Ab0429stemp table.
	 * 
	 * ab0429stemp Ab0429stemp
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 */
	public void remove(DocumentoOS3 ab0429stemp) {
		String query = "DELETE FROM AB0429S00 WHERE ID_DOCUMENTO_029=?";
		this.jdbcTemplate.update(query, ab0429stemp.getIdDocumento097());
	}

	/**
	 * Removes a single row in the Ab0429stemp table.
	 * 
	 * ab0429stemp Ab0429stemp
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 */
	public void removeByIdApertura(DocumentoOS3 ab0429stemp) {
		String query = "DELETE FROM AB0429S00 WHERE TEROS3_029=? AND ANOOS3_029=? AND NUMOS3_029=?";
		this.jdbcTemplate.update(query, ab0429stemp.getTramiteOS3().getOs3()
				.getTeros3061(), ab0429stemp.getTramiteOS3().getOs3()
				.getAnoos3061(), ab0429stemp.getTramiteOS3().getOs3()
				.getNumos3061());
	}

	/**
	 * Finds a list of rows in the Ab0429stemp table.
	 * 
	 * ab0429stemp Ab0429stemp jqGridRequestDto JQGridRequestDto List
	 * <Ab0429stemp>
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS3> findAll(DocumentoOS3 ab0429stemp,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DOCUMENTO_029 IDDOCUMENTO029,t1.TEROS3_029 TEROS3029,t1.ANOOS3_029 ANOOS3029,t1.NUMOS3_029 NUMOS3029,t1.RUTA_PIF_029 RUTAPIF029,t1.NOMBRE_DOC_029 NOMBREDOC029,t1.ID_TIPO_DOC_029 IDTIPODOC029 ");
		query.append("FROM AB0429S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0429stemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0429stemp table using like.
	 * 
	 * ab0429stemp Ab0429stemp jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab0429stemp>
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS3> findAllLike(DocumentoOS3 ab0429stemp,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DOCUMENTO_029 IDDOCUMENTO029,t1.TEROS3_029 TEROS3029,t1.ANOOS3_029 ANOOS3029,t1.NUMOS3_029 NUMOS3029,t1.RUTA_PIF_029 RUTAPIF029,t1.NOMBRE_DOC_029 NOMBREDOC029,t1.ID_TIPO_DOC_029 IDTIPODOC029 ");
		query.append("FROM AB0429S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0429stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0429stemp table.
	 * 
	 * ab0429stemp Ab0429stemp Long
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentoOS3 ab0429stemp) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0429S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0429stemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0429stemp table using like.
	 * 
	 * ab0429stemp Ab0429stemp startsWith Boolean Long
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocumentoOS3 ab0429stemp, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0429S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0429stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0429stemp selected for rup_table
	 * 
	 * ab0429stemp Ab0429stemp jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<TableRowDto<Ab0429stemp>>.
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	// @Override
	public List<TableRowDto<DocumentoOS3>> reorderSelection(
			DocumentoOS3 ab0429stemp, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DOCUMENTO_029 IDDOCUMENTO029,t1.TEROS3_029 TEROS3029,t1.ANOOS3_029 ANOOS3029,t1.NUMOS3_029 NUMOS3029,t1.RUTA_PIF_029 RUTAPIF029,t1.NOMBRE_DOC_029 NOMBREDOC029,t1.ID_TIPO_DOC_029 IDTIPODOC029 ");
		// FROM
		query.append("FROM AB0429S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0429stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DocumentoOS3.class, filterParamList,
				"ID_DOCUMENTO_029");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoOS3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * filterParams Ab0429stemp searchParams Ab0429stemp jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0429stemp>>.
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<DocumentoOS3>> search(DocumentoOS3 filterParams,
			DocumentoOS3 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DOCUMENTO_029 IDDOCUMENTO029,t1.TEROS3_029 TEROS3029,t1.ANOOS3_029 ANOOS3029,t1.NUMOS3_029 NUMOS3029,t1.RUTA_PIF_029 RUTAPIF029,t1.NOMBRE_DOC_029 NOMBREDOC029,t1.ID_TIPO_DOC_029 IDTIPODOC029 ");
		// FROM
		query.append("FROM AB0429S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DocumentoOS3.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_DOCUMENTO_029");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoOS3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0429stemp entity
	 * 
	 * ab0429stemp Ab042stemp Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoOS3 DocumentoOS3) {

		StringBuilder where = new StringBuilder(
				DocumentosOS3TempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (DocumentoOS3 != null && DocumentoOS3.getIdDocumento097() != null) {
			where.append(" AND t1.ID_DOCUMENTO_029 = ?");
			params.add(DocumentoOS3.getIdDocumento097());
		}
		if (DocumentoOS3 != null && DocumentoOS3.getTramiteOS3() != null
				&& DocumentoOS3.getTramiteOS3().getOs3() != null
				&& DocumentoOS3.getTramiteOS3().getOs3().getTeros3061() != null) {
			where.append(" AND t1.TEROS3_029 = ?");
			params.add(DocumentoOS3.getTramiteOS3().getOs3().getTeros3061());
		}
		if (DocumentoOS3 != null && DocumentoOS3.getTramiteOS3() != null
				&& DocumentoOS3.getTramiteOS3().getOs3() != null
				&& DocumentoOS3.getTramiteOS3().getOs3().getAnoos3061() != null) {
			where.append(" AND t1.ANOOS3_029 = ?");
			params.add(DocumentoOS3.getTramiteOS3().getOs3().getAnoos3061());
		}
		if (DocumentoOS3 != null && DocumentoOS3.getTramiteOS3() != null
				&& DocumentoOS3.getTramiteOS3().getOs3() != null
				&& DocumentoOS3.getTramiteOS3().getOs3().getNumos3061() != null) {
			where.append(" AND t1.NUMOS3_029 = ?");
			params.add(DocumentoOS3.getTramiteOS3().getOs3().getNumos3061());
		}
		if (DocumentoOS3 != null && DocumentoOS3.getRutaPif097() != null) {
			where.append(" AND t1.RUTA_PIF_029 = ?");
			params.add(DocumentoOS3.getRutaPif097());
		}
		if (DocumentoOS3 != null && DocumentoOS3.getNombreDoc097() != null) {
			where.append(" AND t1.NOMBRE_DOC_029 = ?");
			params.add(DocumentoOS3.getNombreDoc097());
		}
		if (DocumentoOS3 != null && DocumentoOS3.getTipoDocumento() != null
				&& DocumentoOS3.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_029 = ?");
			params.add(DocumentoOS3.getTipoDocumento().getIdTipoDoc091());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0429stemp entity
	 * 
	 * ab0429stemp Ab0429stemp Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0429stemp
	 *            the ab 0429 stemp
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DocumentoOS3 ab0429stemp,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocumentosOS3TempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0429stemp != null && ab0429stemp.getIdDocumento097() != null) {
			where.append(" AND t1.ID_DOCUMENTO_029 = ?");
			params.add(ab0429stemp.getIdDocumento097());
		}
		if (ab0429stemp != null && ab0429stemp.getTramiteOS3() != null
				&& ab0429stemp.getTramiteOS3().getOs3() != null
				&& ab0429stemp.getTramiteOS3().getOs3().getTeros3061() != null) {
			where.append(" AND t1.TEROS3_029 = ?");
			params.add(ab0429stemp.getTramiteOS3().getOs3().getTeros3061());
		}
		if (ab0429stemp != null && ab0429stemp.getTramiteOS3() != null
				&& ab0429stemp.getTramiteOS3().getOs3() != null
				&& ab0429stemp.getTramiteOS3().getOs3().getAnoos3061() != null) {
			where.append(" AND t1.ANOOS3_029 = ?");
			params.add(ab0429stemp.getTramiteOS3().getOs3().getAnoos3061());
		}
		if (ab0429stemp != null && ab0429stemp.getTramiteOS3() != null
				&& ab0429stemp.getTramiteOS3().getOs3() != null
				&& ab0429stemp.getTramiteOS3().getOs3().getNumos3061() != null) {
			where.append(" AND t1.NUMOS3_029 = ?");
			params.add(ab0429stemp.getTramiteOS3().getOs3().getNumos3061());
		}
		if (ab0429stemp != null && ab0429stemp.getRutaPif097() != null) {
			where.append(" AND UPPER(t1.RUTA_PIF_029) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0429stemp.getRutaPif097().toUpperCase() + "%");
			} else {
				params.add("%" + ab0429stemp.getRutaPif097().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RUTA_PIF_029 IS NOT NULL");
		}
		if (ab0429stemp != null && ab0429stemp.getNombreDoc097() != null) {
			where.append(" AND UPPER(t1.NOMBRE_DOC_029) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0429stemp.getNombreDoc097().toUpperCase() + "%");
			} else {
				params.add("%" + ab0429stemp.getNombreDoc097().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_DOC_029 IS NOT NULL");
		}
		if (ab0429stemp != null && ab0429stemp.getTipoDocumento() != null
				&& ab0429stemp.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_029 = ?");
			params.add(ab0429stemp.getTipoDocumento().getIdTipoDoc091());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
